<div>
	<ul class="display-style-icon list-unstyled row ">
		<#if entries?has_content>
			<#list entries as entry>
				<#assign
					entry = entry
					entryId = entry.getEntryId()
					assetRenderer = entry.getAssetRenderer()
					entryTitle = htmlUtil.escape(assetRenderer.getTitle(locale))
				/>
				<#assign docXml = saxReaderUtil.read(entry.getAssetRenderer().getArticle().getContent()) />
				<#assign ddmimg = docXml.valueOf("//dynamic-element[@name='image_publication']/dynamic-content/text()") />
				<#assign href = docXml.valueOf("//dynamic-element[@name='readmore']/dynamic-content/text()") />
				<#assign publication_note = docXml.valueOf("//dynamic-element[@name='publication_note']/dynamic-content/text()") />
				<li class="lfr-asset-item">
					<div class="taglib-vertical-card entry-display-style ">
						<div class="editIcon">
							<span><@getEditIcon /></span>
						</div>
						<div class="card">
							<a href="${href}" target="_blank">
								<div class="aspect-ratio aspect-ratio-bg-center aspect-ratio-bg-cover" style="background-image: url('${ddmimg}&imagePreview=1')"></div>
							</a>
						</div>
						<div class="cis-text-color">${entryTitle}</div>
						<p class="note">${publication_note}</p>
					</div>
				</li>
			</#list>
		</#if>
	</ul>
</div>
<#macro getEditIcon>
	<#if assetRenderer.hasEditPermission(themeDisplay.getPermissionChecker())>
		<#assign redirectURL = renderResponse.createRenderURL() />
		${redirectURL.setParameter("mvcPath", "/add_asset_redirect.jsp")}
		${redirectURL.setWindowState("pop_up")}
		<#assign editPortletURL = assetRenderer.getURLEdit(renderRequest, renderResponse, windowStateFactory.getWindowState("pop_up"), redirectURL)!"" />
		<#if validator.isNotNull(editPortletURL)>
			<#assign title = languageUtil.format(locale, "edit-x", entryTitle, false) />
			<@liferay_ui["icon"]
				iconCssClass="icon-edit-sign"
				message=title
				url="javascript:Liferay.Util.openWindow({id:'" + renderResponse.getNamespace() + "editAsset', title: '" + title + "', uri:'" + htmlUtil.escapeURL(editPortletURL.toString()) + "'});"
			/>
		</#if>
	</#if>
</#macro>